#pragma once

#include "gmplugin.h"

struct Moderator_t
{
	StringClass IRCNick;
	StringClass InGameNick;
	StringClass Access;
};

struct Command_t
{

};

class Settings
{
public:
	static void Load();
	static void Unload();
	static INIClass* Open_INI(const char* Ini);

	static StringClass Load_String(const char* Ini, const char* Section, const char* Entry);
	static int Load_Int(const char* Ini, const char* Section, const char* Entry);
	static bool Load_Bool(const char* Ini, const char* Section, const char* Entry);
	static float Load_Float(const char* Ini, const char* Section, const char* Entry);

	static void Load_Map_Rules();
	static void Load_Moderators();

	static void Unload_Moderators();
	
	static DynamicVectorClass<StringClass> Load_String_List(const char* Ini, const char* Section); 

	static DynamicVectorClass<StringClass> AutoAnnounceList;
	static bool EnablePageSound, EnableAFKDetector, PageAFKPlayers, EnableEndGameRecs, EnableAuthProtect,
		IsMarathon;
	static StringClass PageSoundFile, BotAcronym, BotName, MapRules, PageColour, IRCHost, IRCHostBackup;
	static StringClass NickServPass, IRCNick, IRCNickBackup, IRCPublicChan, IRCAdminChan, IRCAdminKey;
	static StringClass Rules;
	static int LimitNameLength, AutoAnnounceInterval, IRCPort, IRCPortBackup, AuthProtectInterval;
	static HashTemplateClass<StringClass, Moderator_t*> ModsGameNick, ModsIRCNick;
	static time_t StartTime;
};